/*--------------------------------------------------------------------------*\

    CERRFKT.C      Version 1.0                                     2000 AVM

    This file contains the source CAPI error mapping functions,
    here for Windows - kernel mode driver level.

\*--------------------------------------------------------------------------*/
#ifdef WDM
#   include <wdm.h>
#else
#   include <ntddk.h>
#endif

#include "cerrfkt.h"


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
CAPI_REGISTER_ERROR NtToCapiRegisterError (unsigned long status) {

    CAPI_REGISTER_ERROR fret;

    switch (status) {
    case STATUS_SUCCESS:
        fret = CapiRegNoError;
        break;
    case STATUS_TOO_MANY_SESSIONS:
        fret = CapiToManyAppls;
        break;
    case STATUS_INVALID_PARAMETER:
        fret = CapiLogBlkSizeToSmall;
        break;
    case STATUS_BUFFER_TOO_SMALL:
        fret = CapiMsgBufSizeToSmall;
        break;
    case STATUS_NOT_SUPPORTED:
        fret = CapiAnzLogConnNotSupported;
        break;
    case STATUS_NETWORK_BUSY:
    case STATUS_DEVICE_BUSY:
        fret = CapiRegBusy;
        break;
    case STATUS_INSUFFICIENT_RESOURCES:
        fret = CapiRegOSResourceErr;
        break;
    case STATUS_SERVER_DISABLED:
        fret = CapiRegCtrlerNotSupportExtEquip;
        break;
    case STATUS_SERVER_NOT_DISABLED:
        fret = CapiRegCtrlerOnlySupportExtEquip;
        break;
    default:
        fret = CapiRegNotInstalled;
        break;
    };

    return fret;
}


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
MESSAGE_EXCHANGE_ERROR NtToMessageExchangeError (unsigned long status) {

    MESSAGE_EXCHANGE_ERROR fret;

    switch (status) {
    case STATUS_SUCCESS:
        fret = CapiNoError;
        break;
    case STATUS_INVALID_HANDLE:
        fret = CapiIllAppNr;
        break;
    case STATUS_ILLEGAL_FUNCTION:
        fret = CapiIllCmdOrSubcmdOrMsgToSmall;
        break;
    case STATUS_TOO_MANY_COMMANDS:
        fret = CapiSendQueueFull;
        break;
    case STATUS_DATA_OVERRUN:
        fret = CapiReceiveOverflow;
        break;
    case STATUS_INVALID_PARAMETER:
        fret = CapiUnknownNotPar;
        break;
    case STATUS_DEVICE_BUSY:
        fret = CapiMsgBusy;
        break;
    case STATUS_INSUFFICIENT_RESOURCES:
        fret = CapiMsgOSResourceErr;
        break;
    case STATUS_SERVER_DISABLED:
        fret = CapiMsgCtrlerNotSupportExtEquip;
        break;
    case STATUS_SERVER_NOT_DISABLED:
        fret = CapiMsgCtrlerOnlySupportExtEquip;
        break;
    default:
        fret = CapiMsgNotInstalled;
        break;
    }

    return fret;
}


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
