/*--------------------------------------------------------------------------*\

    CKMDEV.H      Version 1.0                                     2000 AVM

    This file contains the function prototypes for handling
    IoDeviceObjects for CAPI, here for Windows - kernel mode driver level.

\*--------------------------------------------------------------------------*/
#ifndef _ckmdev_h_
#define _ckmdev_h_

#ifdef WDM
#   include <wdm.h>
#else
#   include <ntddk.h>
#endif

#include "capi20.h"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
NTSTATUS DeviceObjectOpen      (void **hDevice);
void     DeviceObjectClose     (void *hDevice);
NTSTATUS DeviceObjectRequest   (void *hDevice,
                                unsigned long IoControlCode,
                                unsigned long InputBufferLength,
                                unsigned long OutputBufferLength,
                                void *Buffer);


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif
