/*
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.service;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;

import de.avm.android.fritzapp.com.ConnectionProblem;

public abstract class NetworkChangedHandler
{
    protected static final boolean DEBUG = false;

    public interface OnNetworkChangedListener
    {
        void onChanged(boolean forceReconnect);
    }

    public static NetworkChangedHandler getInstance(Context context)
    {
        if (mSingleton == null)
        {
            if (context == null)
                throw new IllegalArgumentException("Argument context must not be null");

            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP)
                mSingleton = new NetworkChangedLegacyHandler(context);
            else
                mSingleton = new NetworkChangedLollipopHandler(context);
        }

        return mSingleton;
    }

    public static boolean usesWlanOnlyOption()
    {
        return Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP;
    }

    public Context getContext()
    {
        return mContext;
    }

    public ConnectivityManager getConnectivityManager()
    {
        return mConnectivityManager;
    }

    public abstract void registerCallback(OnNetworkChangedListener listener);
    public abstract void unregisterCallback();
    public abstract ConnectionProblem checkValidConnectivity();

    private static NetworkChangedHandler mSingleton = null;
    private Context mContext;
    private ConnectivityManager mConnectivityManager;

    protected NetworkChangedHandler(Context context)
    {
        mContext = context.getApplicationContext();
        mConnectivityManager = (ConnectivityManager)context
                .getSystemService(Context.CONNECTIVITY_SERVICE);
    }
}
