/* 
 * Copyright 2014 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents WPS info on WLANConfiguration interface as received from the Fritzbox 
 */
public class WPSInfo implements Parcelable
{
	/*
	 * NewX_AVM-DE_WPSMode		Out	String
	 * NewX_AVM-DE_WPSStatus	Out	String
	 * NewX_AVM-DE_WPSAPPIN		Out	String
	*/

	private String mMode;
	private String mStatus;
	private String mApPin = null;
	
	public String getMode()
	{
		return mMode;
	}
	
	public String getStatus()
	{
		return mStatus;
	}
	
	public String getApPin()
	{
		return mApPin;
	}

	public WPSInfo(String mode, String status)
	{
		mMode = mode;
		mStatus = status;
	}

	public WPSInfo(String mode, String status, String apPin)
	{
		mMode = mode;
		mStatus = status;
		mApPin = apPin;
	}

	public WPSInfo(Parcel in)
	{
		mMode = in.readString();
		mStatus = in.readString();
		mApPin = in.readString();
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<WPSInfo> CREATOR =
			new Parcelable.Creator<WPSInfo>()
	{
		public WPSInfo createFromParcel(Parcel in)
		{
			return new WPSInfo(in);
		}

		public WPSInfo[] newArray(int size)
		{
			return new WPSInfo[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeString(mMode);
		out.writeString(mStatus);
		out.writeString(mApPin);
	}
}